'
'*******************************************************************************
'Programm ......... : TWI-Master fr eine mehrstellige Digitalanzeige
'                     - Version: Zeit, Datum, Wochentag
'
'Programminhalt ... : Steuerung mehrerer Digitalanzeigen per TWI-Bus zur Anzeige
'                     - Zeit ........ : hh:mm:ss
'                     - Datum ....... : TT:MM:JJJJ
'                     - Wochentag ... : WT (per einzelne LED)
'                     Je nach Betriebsart knnen u. a. angesteuert werden:
'                     (auch gemischt)
'                     -  7-Segmentanzeigen
'                     - 16-Segmentanzeigen
'                     - LCD-Modul
'                     - einzelne LED sowie Punktmatrixanzeigen
'                     Ermittlung der Zeitangabe ber ein DCF77-Modul
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : V 1.1.31
'Datum ............ : 07.02.2022
'
' Hinweise
' Label A_...          Die mit dem Prfix "A_" versehenen Labels dienen nur dem
'                      schnelleren Auffinden der Zeile im Programmcode.
' Label L_/M_...       Sprungmarken des Programms
'
'-------------------------------------------------------------------------------
'
'Zusatzbibliothek
'----------------
' -
A_000___information:
'
'-------------------------------------------------------------------------------
'00. === I N F O R M A T I O N =================================================
'-------------------------------------------------------------------------------
'Simulator-Betrieb
'-----------------
'$sim                                             'Wartezeit aus
'
'/// Achtung ///
' Diese Zeile ist unbedingt auszukommentieren, bevor der AVR programmiert wird,
' da sonst der AVR nicht korrekt arbeitet.
' Die Aktivierung ist nur fr den Programmlauf im Simulator vorgesehen.
'
'-------------------------------------------------------------------------------
'
A_001_all:                                        'Editmarker: allgemeines
'
'Allgemeines
'-----------
'-Busteilnehmer
' Nach einer neuen Programmierung ist es unbedingt erforderlich, dass alle am
' TWI-Bus angeschlossenen AVR abgeschaltet und wieder neu eingeschaltet werden.
'
'-Adressierung
' Um einen einzelnen Slave ansprechen zu knnen, werden folgende Festlegungen
' zur Adressierung getroffen.
' Die ersten beiden Slaves befinden sich auf der Steuerplatine, die anderen auf
' den jeweiligen Erweiterungsplatinen (zwei je Platine).

' PCB  Slave  ADR H/D   Digit Bedeutung              Zusatz
'-------------------------------------------------------------------------------
'  ST   01     &H22 / 34   01    h-  10 (hh:mm:ss)
'                          02    h-   1 (hh:mm:ss)    Trennzeichen (Doppelpunkt)
'  ST   02     &H24 / 36   03    m-  10 (hh:mm:ss)
'                          04    m-   1 (hh:mm:ss)    Trennzeichen (Doppelpunkt)
'  EW1  03     &H26 / 38   05    s-  10 (hh:mm:ss)
'                          06    s-   1 (hh:mm:ss)
'                                - - - - - - - - - - - - - - - - - - - - - - - -
'  EW1  04     &H28 / 40   07    T-  10 (TT:MM:JJJJ)
'                          08    T-   1 (TT:MM:JJJJ)  Trennzeichen (Doppelpunkt)
'  EW2  05     &H2A / 42   09    M-  10 (TT:MM:JJJJ)
'                          10    M-   1 (TT:MM:JJJJ)  Trennzeichen (Doppelpunkt)
'  EW2  06     &H2C / 44   11    J-1000 (TT:MM:JJJJ)
'                          12    J- 100 (TT:MM:JJJJ)
'  EW3  07     &H2E / 46   13    J-  10 (TT:MM:JJJJ)
'                          14    J-   1 (TT:MM:JJJJ)
'                          - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'  EW3  08     &H30 / 48   15    W-   1 (W)
'                          16    --                     (frei)
'
' Die Prfung auf Slaveanschluss erfolgt bis Adresse &H3E, wenn per Men nicht
' eine geringere Slave-Anzahl gewhlt wurde.
'
'Allgemeine Informationen zur Adressierung beim Bussystem
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'Adresse | R/W | Beschreibung                            | &Hxx   | &DEZ
'----------------------------------------------------------------------------
'0000000 |  0  | General Call Adresse                    |     00 |         0
'0000000 |  1  | Startbyte                               |     01 |         1
'0000001 |  X  | CBUS Adresse                            |  02-03 |   2 -   3
'0000010 |  X  | Reserviert fr ein anderes Busformat    |  04-05 |   4 -   5
'0000011 |  X  | Fr zuknftige Erweiterungen reserviert |  06-07 |   6 -   7
'00001XX |  X  | Fr zuknftige Erweiterungen reserviert |  08-0F |   8 -  15
'11110XX |  X  | 10-Bit Adressierung                     |  70-F7 | 112 - 247
'11111xx |  X  | Fr Zuknftige Erweiterungen Reserviert |  F8-FF | 248 - 255
'
'Eintellung des Potentiometers fr die Helligkeitssteuerung
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'Wird das Potentiometer so eingestellt, dass bei Dunkelheit sich ein Wert von
'ca. 0,5 V (ADC7, Pin 33) ergibt, erhhen sich die ADC-Werte bei ansteigender
'Helligkeit um solche Betrge, die in der Auwerteroutine optimal fr die An-
'passung der PWM-Steuerung fr die Anzeigehelligkeit sind.
'Bei einer hher eingestllter Grundhelligkeit verringert sich der mgliche Steu-
'erungsbereich.

'Ganggenauigkeit bei DCF-Ausfall
'-------------------------------
'Bei Recherchen fand sich dazu folgende Aussage, welchen Weg dazu die Bascom Lib
'geht:
'Config DCF ist nicht mit einer asynchronen RTC an Timer2 kombinierbar, sondern
'emuliert eine RTC mit der Main-CLK. Dies bedeutet, dass der interne RC-Oszilla-
'tor der ATmegas dafr nicht geeignet ist und ein externer Quarz nur einge-
'schrnkt.
'1-2 Sekunden Abweichung in 24h sind nur mit Trimmkondensatoren erreichbar,
'die die blichen 16-20 pF Kondensatoren am Quarzeingang ersetzen und mit denen
'man die Ganggenauigkeit justieren kann.

A_010_bedienung:                                  'Editmarker: Bedienung
'
'Bedienung, Anzeige und Signalisierung
'-------------------------------------
'Bedienung
' Die Eingaben erfolgen ber Taster. Es knnen maximal 9 Taster angeschlossen
' werden. ber eine Kodierung gelangt die Information ber eine gedrckte Taste
' an den MC.
' Weitere Informationen knnen dem Handbuch entnommen werden.
'
'Anzeige und Signalisierung
' Zur Anzeige wird eine RGB-LED und fr die Tonausgabe ein Beeper eingesetzt.
'
'-------------------------------------------------------------------------------
A_020_historie:                                   'Editmarker: Historie
'
'Versionsbersicht
'-----------------
'Label "A_163_version": LCD-Anzeige der Versionsnummer aktualisiern
'
'
'
'
'
'V 1.0.30  08.02.2022 - Erweiterung . : - zustzliche LCD-Anzeigen
'                                         PA: 3 - ADC (Anzeige Sensorwert)
'                                         PA: 4 - PWM (Anzeige-Helligkeit)
'                     - AVR ......... : - 89%
'V 1.0.31  07.02.2022 - Erweiterung . : - DCF-Ausfall > 3 Minuten wird durch
'                                         eine blau blitzende LED angezeigt
'                                         (Abfrage von Statusbit.2)
'                                       - LCD-Anzeige bei UTC-Betrieb
'                     - AVR ......... : - 87%
'V 1.0.33  05.02.2022 - nderung .... : - Helligkeitssteuerung so angepasst
'                                         dass ein Sensorwert ab 201 (Poti
'                                         bei Dunkelheit) zur PWM-Regelung
'                                         verwendet wird
'V 1.0.35  30.01.2022 - Erweiterung . : - LCD in den Modis TT:MM:JJ oder ~JJJJ
'                                       - Optimierung der LCD-Anzeige im Modus
'                                         Men
'                     - AVR ......... : - 83%
'V 1.0.37  29.01.2022 - nderung .... : - LCD-Wochentaganzeige korrigiert
'                                       - nderung der Grundhelligkeit auch
'                                         bei ausgeschalteter Sensorspannung
'                     - AVR ......... : - 78%
'V 1.0.44  30.12.2021 - nderung .... : - BODLEVEL 0 (-> 4,0 V eingestellt)
'                                       - BODEN    0 (enabled)
'                                       - EEpromdummy fr ADR 0 (sinnvoll?)
'V 1.0.53  28.12.2021 - Erweiterung . : - Sensor-Abfrage Helligkeit
'                     - Bearbeitung . : - Kommentierung
'                     - AVR ......... : - 77%
'V 1.0.60  27.12.2021 - Erweiterung . : - Stundeneinstellung manuell
'                     - AVR ......... : - 65%
'V 1.0.62  24.12.2021 - Erweiterung . : - Anzeige UTC-Zeit
'                                       - Ansteuerung LED (Helligkeit)
'                     - AVR ......... : - 49%
'V 1.0.76  22.12.2021 - Erweiterung . : - Datenbetragung komplettiert
'                                       - Anzeigesteuerng Betriebsarten durch
'                                         bertragung von Sonderzeichen >99
'                     - AVR ......... : - 35%
'V 1.0.77  20.12.2021 - nderung .... : - Einschwingzeit auf 2 s festgelegt
'V 1.0.81  18.12.2021 - nderung .... : - DCF-Check 0 > 2 (bessere Prfung)
'                     - AVR ......... : - 30%
'V 1.0.86  14.12.2021 - Prfung ..... : - Daten per TWI bertragen
'V 1.0.87  09.12.2021 - Prfung ..... : - DCF-Funktion besttigt
'                                       - Frequenz fr LCD-K/H erhht
'                     - AVR ......... : - 29%
'V 1.0.89  07.12.2021 - Erweiterung . : - Anschluss LCD
'                     - AVR ......... : - 25%
'V 1.0.96  28.11.2021 - Erweiterung . : - Betriebsartenumschaltung
'V 1.0.98  21.11.2021 - Bearbeitung . : - Kommentierung
'V 1.0.99  13.11.2021 - Information . : - Beginn der Softwareentwicklung
'                     - AVR ......... : -  0%
'
'-------------------------------------------------------------------------------
'
'Informationen zur Software
'--------------------------
' Inhalt                                                                | Zeile
'-------------------------------------------------------------------------------
' 01. Allgemeine Informationen ........................................ |  264
' 02. Abkrzungsbersicht ............................................. |  282
' 03. Compilereinstellungen ........................................... |  298
' 04. Funktionsbeschreibung ........................................... |  321
'       Allgemeines ................................................... |  323
'       Anzeige und Signalisiereung ................................... |  329
'        Farbe   | Bedeutung .......................................... |  333
'        Tonfolge | Bedeutung ......................................... |  345
' 05. Interrupt ....................................................... |  358
' 06. Einstellung der Fuse- und Lock-Bits ............................. |  367
' 07. Anschluschema fr den AVR ATmega16(A) .......................... |  415
' 08. I/O-Ports ....................................................... |  477
'      Abkrzungen fr die Signalbezeichnung .......................... |  479
' 09. EEprom-Belegung ................................................. |  569
' 10. Allgemein ....................................................... |  584
' 11. AVR Initialisierung ............................................. |  589
'      Watchdog ....................................................... |  602
'      Schnittstelle .................................................. |  606
'      Compilereinstellung ............................................ |  611
' 12. Fuse- und Lockbits .............................................. |  619
' 13. Deklaration ..................................................... |  640
' 14. Konfiguration ................................................... |  802
'      I/O-Port ....................................................... |  804
'      Timer .......................................................... |  860
'      Systemzeit ..................................................... |  881
'      LCD ............................................................ |  892
'      DCF-Modul ...................................................... |  902
'      Analog/Digital Konverter ....................................... |  916
'      Interrupt ...................................................... |  937
' 15. Alias ........................................................... |  948
'      Eingang (digital) .............................................. |  954
'      Ausgang (digital) .............................................. |  957
'      Eingang (digital) .............................................. |  962
'      Ausgang (digital) .............................................. |  964
'      Eingang (digital) .............................................. |  970
'      Ausgang (digital) .............................................. |  975
' 16. Initialisierung ................................................. |  986
'      Konstanten ..................................................... |  990
'      EEprom ......................................................... | 1007
'      Lebenszeichen .................................................. | 1057
' 20. Programm ........................................................ | 1138
'      Initialisierung ................................................ | 1144
'      Auswertungen der Tasten ........................................ | 1230
'      DCF ............................................................ | 1663
'      Datenbertragung ............................................... | 1713
'      Helligkeitssteuerung ........................................... | 1776
' 30. Interruptroutine ................................................ | 1836
'      Timer 0 ........................................................ | 1844
'      PWM-Steuerung Anzeige .......................................... | 1906
' 40. Unterprogramm-Gosub ............................................. | 1951
'      Tonausgabe ..................................................... | 1955
'      DCF-Statusabfrage .............................................. | 1992
'      Abfrage der Tasten ............................................. | 2012
'      LED-Ausschaltung ............................................... | 2055
'      Anzeige lschen ................................................ | 2065
'      Daten an die Slaves senden ..................................... | 2080
'      DCF-Auswertung ................................................. | 2096
' 50. Unterprogramm-Call .............................................. | 2193
'      LCD-Ausgabe .................................................... | 2197
' 60. Initialisierung der Slaves ...................................... | 2222
' 70. Funktion ........................................................ | 2228
' 80. Datenbereich .................................................... | 2234
'-------------------------------------------------------------------------------
'
'01. Allgemeine Informationen
'----------------------------
'Stromversorgung
' -Einzel-, Doppel- oder Direkteinspeisung
' -Direkteinspeisung: +5,0 V (P5,0V)
'
'Taktfrequenz
' Fr die Erzeugung der Taktfrequenz wird ein Quarz (8,0 MHz) verwendet.
'
'Programmierung
' Die Programmierung des MCs kann extern oder ber die vorhandene Schnittstelle
' erfolgen.
' Zur Programmierung wurde das Modul "USBasp" verwendet, welches ber eine
' USB-Schnittstelle angeschlossen wird. Es kann direkt ber eine, in BASCOM
' integrierte Einstellung angesprochen werden.
'
A_022_abk:                                        'Editmarker: Bakrzung
'
'02. Abkrzungsbersicht
'-----------------------
' HGB ... : Hintergrundbeleuchtung (LCD)
' MC .... : Mikrocontroller
' PWM ... : Pulsweitenmodulation (LCD-Kontrast)
' TWI ... : Two-wire Serial Interface (entspricht technisch dem I2C-Bus)
'
'Darstellung von Zeit und Datum
' hh .... : Sunden
' mm .... : Minuten
' ss .... : Sekunden
' DD .... : Tag
' MM .... : Monat
' JJJJ .. : Jahr
' WT .... : Wochentag

'03. Compilereinstellungen
'-------------------------
' Hinweise fr ATmega8/ATmega16 mit 1024 Byte SRAM
' Quelle:
' //halvar.at/elektronik/kleiner_bascom_avr_kurs/speicher_hwstack_swstack_frame/
'
' HW-Stack .. - Empfehlung: 40 Byte bei INT, sonst 10 Byte ausreichend
'  32 Byte fr INT + je GOSUB 2 Byte, wenn bei INT ein GOSUB erfolgt
'  (bei Verschachtelung ... + n x 2 Byte)
'
' SW-Stack .. - Empfehlung: 32 Byte (recht komplexe Aufrufe werden abgedeckt)
'   2 Byte fr jede bergebene Variable einer GOSUB-Routine + 2 Byte fr jede
'   LOCAL-Variable innerhalb einer GOSUB
'   (bei Verschachtelung ... n x 2 Byte)
'
' Frame-Space - Empfehlung: 60 Byte sollten alles abdecken
'                           (bei wenig Speicher verkleinern)
'  Beispiel:
'   2 x BYTE        =  2 Byte (erster und zweiter Parameter)
'   1 x WORD        =  2 Byte (dritte Parameter)
'   1 x STRING * 10 = 11 Byte (inkl. Abschlussbyte; vierter Parameter)
'   3 x BYTE        =  3 Byte (lokale Variablen)
'
'04. Funktionsbeschreibung
'-------------------------
' Allgemeines
' -----------
' Beim Anschluss des Microkontrollers gibt es keine Besonderheiten zu beachten.
' Die Takterzeugung erfolgt mitg einem Quarz, die Programmierung ber die SPI-
' Schnittstelle.
'
' Anzeige und Signalisiereung
' ---------------------------
' Am Port D (.0-.2) ist eine RGB-LED angeschlossen.
'  Kodierung der Farbe
'  Farbe   | Bedeutung
'-------------------------------------------------------------------------------
'  rot     | Anzeige von Zusatzinformationen
'  grn    | Anzeige der MEZ (Sommerzeit)
'  blau    | Anzeige Status DCF (DCF-Ausfall: blitzende LED)
'  gelb    | Anzeige der MEZ (Winterzeit)
'  cyan    |
'  magenta | Anzeige der UTC-Zeit
'  wei    |
'
' Am Port B.4 ist ein Signalgeber (Beeper) angeschlossen
'  Kodierung der Tonsequenz (Morsecode)
'  Tonfolge | Bedeutung
'-------------------------------------------------------------------------------
'  e: .        Slave erkannt
'  s: ...      Neustart
'  t: -        Slave nicht erkannt
'...............................................................................

'Betriebsarten
'~~~~~~~~~~~~~
'Diese werden in der Variablen <V_pa> hinterlegt:
'1: Anzeige der Zeit
'2: Anzeige der Zeit (UTC); UTC= Winterzeit- 1h, UTC= Sommerzeit- 2h
'
'05. Interrupt
'-------------
' Siehe Hinweise zu: Timer, Watchdog, ...
' Zustzlich ist das Resetsignal vom Programmiergert am Port D.3 (INT1) ange-
' schlossen. Damit wird erkannt, wenn einer der MC der angeschlossenen Slaves
' programmiert wird.
' In diesem Fall wird die Anzeige ausgeschaltet und nach Abschluss der Pro-
' grammierung ein Programmneustart durchgefhrt.
'
'06. Einstellung der Fuse- und Lock-Bits
'---------------------------------------
' - Fuse-Einstellungen fr Brenner USBasp (Bascom)
'   Die aktuellen Einstellungen befinden sich im Abschnitt "A_120_fuse".
'
' - Fuse-bersicht
'   Die angegebenen HEX-Werte knnen direkt in den compilierten Programmcode
'   eingetragen werden, falls dies untersttzt wird.
'   Beim USBasp unter Bascom ist dies nicht mglich.
'
' Bedeutung der Fuse/Lock-Bit-Einstellungen (Beispiel)
' Name              ATmega8(A)
'   Calibration 0   BD  (ohne Bedeutung)
'   Calibration 1   BC  (ohne Bedeutung)
'   Calibration 2   B7  (ohne Bedeutung)
'   Calibration 3   B7  (ohne Bedeutung)
' * Lockbits        FF
'    Lockbit 65       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 43       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 21       11: No memory lock features enabled for parallel ...
' * Fusebits        FA
'    Fusebit C         1: BODLEVEL 2.7V
'    Fusebit B         1: BODEN disabled
'    Fusebit KLA987   111010: Ext. Crystal/Resonator Low Freq.
' * Fusebits Hight  D1
'    Fusebit High M    1: Disable OCD
'    Fusebit High J    1: Disable JTAG
'    Fusebit High I    0: SPI enabled
'    Fusebit High H    1: CKOPT 1
'    Fusebit High G    0: Preserve EEPROM when chip erase
'    Fusebit High FE  00: 1024 word boot size, C00
'    Fusebit High D    1: Reset vector is $0000
'
'/// Achtung ///
'- Fusebit High M
'  Bei dem Wert 0 ist mit einfachen Brennern kein Programmieren mehr mglich,
'  da dafr die Reset-Funktion erforderlich ist.
'
' /// Achtung ///
'Gltig fr MC mit folgenden Einstellmglichkeiten:
' - CKSEL
'   Wird CKSEL3= 0 gesetzt, arbeitet der MC nur noch mit einem externen RC-
'   Generator [f= 1/(3RC); C>= 22p].
'
' - RSTDISBL
'   Wird RSTDISBL= 1 gesetzt, ist mit einfachen Brennern kein Programmieren
'   mehr mglich, da dafr die Reset-Funktion unbedingt erforderlich ist.
'
'07. Anschluschema fr den AVR ATmega16(A)
'------------------------------------------
A_070_pin:                                        'Editmarker: Pin
'
'/// Achtung ///
' Die Pinbelegung bezieht sich auf einen ATmega16(A) im DIL40-Gehuse.
' (Die Belegung ist kompatibel mit einem ATmega32(A) mit mehr Programmspeicher.)
'
'                    -----------------|_|-----------------
' [-]     T_QA ---> | 1 [PB0]                     [PA0] 40| ---- (RES_1)  [.]
' [-]     T_QB ---> | 2 [PB1]                     [PA1] 39| ---- (RES_2)  [.]
' [-]     T_QC ---> | 3 [PB2, INT2]               [PA2] 38| ---- (RES_3)  [.]
' [-]     T_QD ---> | 4 [PB3, OC0]                [PA3] 37| ---- (RES_4)  [.]
' [-]      Ton <--- | 5 [PB4]                     [PA4] 36| ---- (RES_5)  [.]
' [$]     MOSI <--- | 6 [PB5, MOSI]               [PA5] 35| ---- (RES_6)  [.]
' [$]     MISO ---> | 7 [PB6, MISO]               [PA6] 34| ----          [.]
' [$]     SCK  <--- | 8 [PB7, SCK]                [PA7] 33| <--- HEL_S    [%]
' [1]   /R_STE ---> | 9 [/Reset]                 [AREF] 32| -||- C        [%]
' [=]    P5,0V ==== |10 [VCC]                    [AGND] 31| ==== GND      [=]
' [=]      GND ==== |11 [GND]                    [AVCC] 30| ==== P5,0V      [=]
' [+]       QZ ++++ |12 [XTAL2]                   [PC7] 29| ---> LCD_DB7  [~]
' [+]       QZ ++++ |13 [XTAL1]                   [PC6] 28| ---> LCD_DB6  [~]
' [-]   RGB_rt <--- |14 [PD0, RXD]                [PC5] 27| ---> LCD_DB5  [~]
' [-]   RGB_gn <--- |15 [PD1, TXD]                [PC4] 26| ---> LCD_DB4  [~]
' [-]   RGB_bl <--- |16 [PD2, INT0]               [PC3] 25| ---> LCD_E    [~]
' [^]   /Reset ---> |17 [PD3, INT1]               [PC2] 24| ---> LCD_RS   [~]
' [-]  HEL_ANZ <--- |18 [PD4]                [SDA, PC1] 23| <--> SDA      [#]
' [-]  LCD_KON <--- |19 [PD5]                [SCL, PC0] 22| ---> SCL      [#]
' [.]          ---- |20 [PD6]                     [PD7] 21| <--- DCF      [^]
'                    -------------------------------------
'
' Standard-Einstellungen nach dem Programmstart
'  [^]: Impuls              [~]: unbestimmt          [&]: PWM
'  [0]: aus (GND)           [1]: ein (Vcc)           [%]: analog
'  [$]: SPI-Bus             [W]: 1-Drahtbus          [#]: I2C-Bus
'  [=]: Stromversorgung     [+]: Quarz               []: nicht verwendbar
'  [.]: nicht angeschlossen (Reservekanal)           [-]: nicht relevant
'
' Datenrichtung ..... : ---- / ---> / <--- / <-->
' Stromversorgung ... : ====
' Quarz ............. : ++++
' Kondensator ....... : -||-
'
'Allgemein
'~~~~~~~~~
' Px,yV   : Stromversorgung P5,0V / P3,3V
' GND     : Stromversorgung Masse
'
' MISO    : Programmieranschlu
' MOSI    : Programmieranschlu
' SCK     : Programmieranschlu
'
' QZ      : Anschlu Quarz
'
' DA      : digitaler Ausgang
' DE      : digitaler Eingang
' PG      : Programmierung
' SV      : Stromversorgung
' SPI     : Busprotokoll
' TWI     : Busprotokoll
' USI     : Busprotokoll (universelle Schnittstelle)
'
'08. I/O-Ports
'-------------
'Abkrzungen fr die Signalbezeichnung
'-------------------------------------
'Prfix
'~~~~~~
' DCF     : Signal vom DCF77-Modul
' HEL_    : Helligkeit (Steuerung oder Sensor)
' LCD_    : LC-Display
' /R_     : Reset fr MC je nach DIL-Schalterstellung
' /Reset  : Resetsignal vom Programmiergert
' RES_    : Reserve Kanal auf Steckverbinder
' RGB_    : Anzeige RGB-LED
' T_Q<x>  : Taste (x: A, B, C, D) BCD-kodiert vom IC
' Ton     : Signalausgabe
'
'Suffix
'~~~~~~
' _rt     : LED: Farbe rot
' _gn     : LED: Farbe grn
' _bl     : LED: Farbe blau
'
' _<n>    : Kanalnummer (n: 1-6)
' _KON    : LCD: Kontraststeuerung
' _E      : LCD: Steuersignal (Auswahl)
' _RS     : LCD: Steuersignal (Befehl, Daten)
' _DB4    : LCD: Datenbit 4   (Daten)
' _DB5    : LCD: Datenbit 5   (Daten)
' _DB6    : LCD: Datenbit 6   (Daten)
' _DB7    : LCD: Datenbit 7   (Daten)
'
' _ANZ    : Helligkeit: Steuerung der Anzeige
' _S      : Helligkeit: Sensor
' _STE    : Resetsignal fr MC_Steuerung
'
' %         Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -   : SV  P5V ........ | ............. | Stromversorgung .............. | 10
' -   : SV  GND ........ | ............. | Stromversorgung .............. | 11
' -   : SV  P5,0V ...... | ............. | Stromversorgung .............. | 30
' -   : SV  GND ........ | ............. | Stromversorgung .............. | 31
' -   : SV  P5,0V ...... | ............. | Referenzspannung ............. | 32
' -   : PRG /Reset ..... | ............. | Programmierung/Reset des MCs . |  9
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... | 12
' -   : QZ  Frequenz ... | ............. | Frequenznormal mit Quarz ..... | 13

' Port A    Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: ..  ............ | (RES_1) ..... | Reservekanal 1 ............... | 40
' - .1: ..  ............ | (RES_2) ..... | Reservekanal 2 ............... | 39
' - .2: ..  ............ | (RES_3) ..... | Reservekanal 3 ............... | 38
' - .3: ..  ............ | (RES_4) ..... | Reservekanal 4 ............... | 37
' - .4: ..  ............ | (RES_5) ..... | Reservekanal 5 ............... | 36
' - .5: ..  ............ | (RES_6) ..... | Reservekanal 6  .............. | 35
' - .6: ..  ............ | ............. | .............................. | 34
' - .7: AE  Helligkeit . | HEL_S ....... | Sensoreingang................. | 33
'
'Port B     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DE  Tastencode . | T_QA ........ | Tastenwert BCD-kodiert ....... |  1
' - .1: DE  Tastencode . | T_QB ........ | Tastenwert BCD-kodiert ....... |  2
' - .2: DE  Tastencode . | T_QC ........ | Tastenwert BCD-kodiert ....... |  3
' - .3: DE  Tastencode . | T_QD ........ | Tastenwert BCD-kodiert ....... |  4
' - .4: DA  Signal ..... | Ton ......... | Signalisierung ............... |  5
' - .5: PRG MOSI ....... | MOSI ........ | Programmierung ............... |  6
' - .6: PRG MISO ....... | MISO ........ | Programmierung ............... |  7
' - .7: PRG SCK ........ | SCK ......... | Programmierung ............... |  8
'
'Port C     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: B   Takt  (Bus). | SLC ......... | TWI-Bussystem ................ | 22
' - .1: B   Daten (Bus). | SDA ......... | TWI-Bussystem ................ | 23
' - .2: DA  LCD ........ | LCD_RS ...... | Befehl, Daten ................ | 24
' - .3: DA  LCD ........ | LCD_E ....... | Enable ....................... | 25
' - .4: DA  LCD ........ | LCD_DB4 ..... | Datenbit 4 ................... | 26
' - .5: DA  LCD ........ | LCD_DB5 ..... | Datenbit 5 ................... | 27
' - .6: DA  LCD ........ | LCD_DB6 ..... | Datenbit 6 ................... | 28
' - .7: DA  LCD ........ | LCD_DB7 ..... | Datenbit 7 ................... | 29
'
'Port D     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  Anzeige .... | RGB_rt ...... | Statusanzeige ................ | 14
' - .1: DA  Anzeige .... | RGB_gn ...... | Statusanzeige ................ | 15
' - .2: DA  Anzeige .... | RGB_bl ...... | Statusanzeige ................ | 16
' - .3: DE  /R.-Abfrage  | /Reset ...... | Programmierung aktiv ......... | 17
' - .4: DA  PWM HEL .... | HGB_ANZ ..... | Helligkeitssteuerung ......... | 18
' - .5: DA  PWM KON .... | LCD_KON ..... | LCD-Kontraststeuerung ........ | 19
' - .6: ..  ............ | ............. | .............................. | 20
' - .7: DE  Zeitsignal . | DCF ......... | DCF-Signaleingang ............ | 21
'
A_090_eeprom:                                     'Editmarker: Eprom
'
'09. EEprom-Belegung
'-------------------
'Adresse   | Inhalt
' Dez  Hex |
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' 000  00  | --: (EEpromdummy)
' 001  01  | PA: Programmauswahl
' 002  02  | AC: LCD Anzeigekontrast
' 003  03  | AH: Helligkeit Anzeige
' 004  04  | LH: Helligkeit LED
' 005  05  | SA: Slaveanzahl
' 006  06  | SH: Sensor Helligkeit
' 007  07  | EA: Einstellung LCD-Anzeige (Format Datum: TT:MM:JJJJ)
'
'-------------------------------------------------------------------------------
'10. === A L L G E M E I N =====================================================
'-------------------------------------------------------------------------------
A_100___allgemein:                                'Editmarker: Allgemein
A_110_def:                                        'Editmarker: Definition
'
'11. AVR Initialisierung
'-----------------------
   $regfile = "m16def.dat"                        'Prozessor ....... : ATmega16
'  $regfile = "m16adef.dat"                       'Prozessor ....... : ATmega16A

   $crystal = 8000000                             'Quarzfrequenz ... : 8,0 MHz

'Hinweis
' Es kann ein ATmega16(A) oder ein Atmega32(A) eingesetzt werden.
' Zu verwenden ist dann
' $regfile = "m16def.dat" bzw. $regfile = "m16adef.dat"
' $regfile = "m32def.dat" bzw. $regfile = "m32adef.dat"

'Watchdog
'--------
   Config Watchdog = 2048                         'Reset nach Timeout 2048 ms

'Schnittstelle
'-------------
' ggf. fr eine Ausgabe im Simulator-Feld UART
' $baud = 9600                                    'Baudrate ........ : 9600
                                                  '9600/19200/38400/57600/115200
'Compilereinstellung
'-------------------                              'bisher:
   $hwstack = 92                                  '64
   $swstack = 92                                  '64
   $framesize = 128                               '92                                                              '--

A_120_fuse:                                       'Editmarker: Fuse
'
'12. Fuse- und Lockbits
'----------------------
'USBasp: Werte generiert mit "Write PRG"

' $PROG &HFF, &H3C, &HD1, &H00
'
' FF: 11 11 11
' 3C: 0 0 111100
' D1: 1 1 0 1 0 00 1
' 00: 0
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' Archiv
' $PROG &HFF, &H3C, &HD1, &H00 -> V~44   BODEN 0   : berwachung ein
' $PROG &HFF, &H7C, &HD1, &H00 -> V~44   BODLEVEL 0: 2,7 V -> 4,0 V
' $prog &HFF, &HFC, &H91, &H00 ->        Korrektur: JTAG deaktivieren
'
'-------------------------------------------------------------------------------
'
A_000_deklaration:                                'Editmarker: Deklaration
A_130_deklaration:                                'Editmarker: Deklaration
'
'13. Deklaration
'---------------
'Subrotinen (Call)
'LCD-Ausgabe
   Declare Sub Cup_lcd(byval Lcd_z1 As String * 16 , _
                       Byval Lcd_z2 As String * 16 , _
                       Byval Lcd_time As Byte)

'Variablen im EEprom und deren Zuweisung
   Dim E_00 As Eram Byte                          '&H00   : EEpromdummy
   Dim E_pa As Eram Byte                          '&H01 PA: Programmauswahl
   Dim E_ac As Eram Byte                          '&H02 AC: Anzeigekontrast
   Dim E_ah As Eram Byte                          '&H03 AH: Anzeige Helligkeit
   Dim E_lh As Eram Byte                          '&H04 LH: LED Helligkeit
   Dim E_sh As Eram Byte                          '&H05 SH: Steuerung Helligkeit
   Dim E_sa As Eram Byte                          '&H06 SA: Slaveanzahl
   Dim E_ea As Eram Byte                          '&H07 EA: Einstellung LCD

   Dim V_pa As Byte                               'PA: Programmauswahl
   Dim V_ac As Byte                               'AC: Anzeige Kontrast
   Dim V_ah As Byte                               'AH: Anzeige Helligkeit
   Dim V_lh As Byte                               'LH: LED Helligkeit
   Dim V_sh As Byte                               'HS: Steuerung Helligkeit
   Dim V_sa As Byte                               'SA: Slaveanzahl
   Dim V_ea As Byte                               'EA: Einstellung Anzeige LCD

   Dim V_z1 As Single                             'Hilfvariable 1, Typ Single
   Dim V_z2 As Single                             'Hilfvariable 2, Typ Single
   Dim V_hz As Byte                               'Zeit Stunden Zehner
   Dim V_he As Byte                               'Zeit Stunden Einer
   Dim V_mz As Byte                               'Zeit Minuten Zehner
   Dim V_me As Byte                               'Zeit Minuten Einer
   Dim V_sz As Byte                               'Zeit Sekunden Zehner
   Dim V_se As Byte                               'Zeit Sekunden Einer

'TWI (Datenbertragung)
   Dim Slv_adr As Byte                            'Slave Adresse
   Dim Slv_wer As Byte                            'Wert
   Dim Slv_prf As Byte                            'Prfwert

'Helligkeitsautomatik
   Dim T_hgb As Word                              'Zeitzhler
   Dim Adc_k7 As Word                             'ADC: Wert Kanal 7
   Dim Adc_sen As Word                            'Helligkeitswert
   Dim V_kf As Byte                               'angepasster PWM-Wert
   Dim Kf_ah As Word                              'Korrekturfaktor fr PWM-Wert
   Dim F_hgb As Bit                               'Helligkeit ermitteln

'Zeit
' Zeit fr die Anzeige
   Dim Utc_sec As Byte
   Dim Utc_min As Byte
   Dim Utc_hour As Byte
   Dim Utc_day As Byte
   Dim Utc_month As Byte
   Dim Utc_year As Byte
   Dim Utc_wt As Byte                             'Wochentag
   Dim Utc_mez As Byte                            '1: MEZ   2: MESZ
   Dim Tag_sec As Long                            'Tagessekunden
   Dim Bsec As Byte , Bmin As Byte At Bsec + 1 , Bhour As Byte At Bmin + 1

' letztes Datum
   Dim Old_day As Byte                            'Tag
   Dim Old_month As Byte                          'Monat
   Dim Old_year As Byte                           'Jahr
   Dim Old_wt As Byte                             'Wochentag

'Flag
' Allgemein
   Dim F_ze As Bit                                'Zeiteinstellung
   Dim F_err As Bit                               'DCF: Error
   Dim F_dok As Bit                               'DCF: Signal ok
   Dim F_dsa As Bit                               'DCF: Signalausfall
   Dim F_dpr As Bit                               'DCF: Prfung Status

   Dim F_tas As Bit                               'Tastenauswertung
   Dim F_as As Bit                                'Anzeigesteuerung
   Dim F_sta As Bit                               'Startdurchlauf
   Dim F_wt As Bit                                'Wochentag

   Dim F_sec As Bit                               'UP Sectic
   Dim F_us As Bit                                'Anzeige wird umgeschaltet

   Dim F_rt As Bit                                'LED rot
   Dim F_gn As Bit                                'LED grn
   Dim F_bl As Bit                                'LED blau

' Fehler
'%
' Toggle
'%

'Merker
' Hilfsmerker
   Dim Hm_mc As Byte                              'Morsecode
   Dim Hm_sec As Long                             'Differenzsekunden
   Dim Hm_tim As Long                             'Zeitwert in sekunden
   Dim M_slv As Byte                              'letzte Slave-Adresse
   Dim M_wer As Byte                              'letzter Tastenwert
   Dim M_mod As Byte                              'Mode

'Konstante
' Allgemein
   Dim K_pa As Byte                              'System: Betriebsart
   Dim K_twi As Byte                              'TWI: Zeitkonstante
   Dim K_azk As Byte                              'LCD: Kontrast
   Dim K_azh As Byte                              'LCD: Helligkeit
   Dim K_azl As Byte                              'LED: Helligkeit
   Dim K_jth As Byte                              'DCF: Jahrtausend/Jahrhundert
   Dim K_slv As Byte                              'Slave: Anzahl
   Dim K_mod As Byte                              'Mode:  Anzahl

   Dim K_azd As Word                              'Anzeigedauer Programmauswahl

'String
' Hilfsstring
   Dim Hs01 As String * 1                         'Hilfsstring "  *"
   Dim Hs03 As String * 3                         'Hilfsstring " 3*"
   Dim Hs05 As String * 5                         'Hilfsstring " 5*"
   Dim Hs10 As String * 10                        'Hilfsstring "10*"
   Dim Hs16 As String * 16                        'Hilfsstring "16*"
   Dim Hs_jt As String * 2                        'Hilfsstring "00" oder "20"
   Dim Lcd_alt1 As String * 16                    'LCD: Zeile 1 alt
   Dim Lcd_alt2 As String * 16                    'LCD: Zeile 2 alt
' Morsezeichen
   Dim Hs_mor As String * 5                       'Hilfsstring Morsen
' Zeit und Datum
   Dim Hs_wt As String * 2                        'Wochentag
   Dim Hs_mod As String * 2                       'Modus
   Dim Hs_zt As String * 16                       'Zeit
   Dim Hs_da As String * 16                       'Datum

'Timer
' Voreinstellwerte
   Dim T0_tve As Byte                             'Timer 0: Voreinstellwert

'Variable
' Allgemein
' Tasten
   Dim T_wer As Byte                              'Tastenwert (Wert)
   Dim T_cod As Byte                              'Tastencode (Abfrage)
   Dim T_zei As Byte                              'Tastendruckzeit
   Dim V_hel As Byte                              'Steuerung Anzeigehelligkeit

'Zhler
' Hilfszhler
   Dim Hz01 As Byte                               'Hilfszhler 01
   Dim Hz02 As Byte                               'Hilfszhler 02
   Dim Hz_mz As Byte                              'Morsezeichen
' Taktzhler
'  Zeit
   Dim Z_led As Byte                              'Zeitzhler
   Dim Z_kon As Byte                              'Einstellung Kontrast
   Dim Z_hel As Byte                              'Einstellung Helligkeit
   Dim T_azd As Word                              'Anzeigedauer [s]
   Dim T_dcf As Byte                              'Anzeige DCF-Ausfall
   Dim Z_dcf As Byte                              'Zhler Statusbit.2
'
'-------------------------------------------------------------------------------
'
A_141_port:                                       'Editmarker: Port
'
'14. Konfiguration
'-----------------
'I/O-Port
'--------
'Port A
' Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddra = &B0000_0000                             'PA0-7 Ein (PA.7 E_analog)
' Pullup-Widerstand (passiv [0], aktiv [1])
   Porta = &B1111_1111                            'PA0-7 aktiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port B
' Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0001_0000                             'PB0-3, 5-7 Aus; PB4 Aus
' Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B1110_1111                            'PB0-7 aktiv, PB4 passiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port C
' Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrc = &B1111_1100                             'PC0,1 Ein, PC2-7 Aus
' Pullup-Widerstand (passiv [0], aktiv [1])
   Portc = &B0000_0000                            'PC0-7 passiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port D
' Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B0011_0111                             'PD0-2, 4-5 Aus; PD3, 6-7 Ein
' Pullup-Widerstand (passiv [0], aktiv [1])
   Portd = &B0000_1000                            'PD0-2, 4-7 passiv; PD3 aktiv

'Bibliothek (Betriebsart: TWI)
' Die Bibliothek ist Bestandteil von BASCOM.
'
' /// Achtung ///
' Wird sie verwendet, bleibt der in BASCOM integrierte Simulator bei dem Befehl
' "I2CSTOP" stehen. => zum Testen im Simulator auskommentieren!

A_131_twi:                                        'Editmarker: TWI-Bus
'
'Festlegung der Kanle fr die TWI-Betriebsart (Hardware I2C/TWI)
'----------------------------------------------------------------
'Setzt in Abhngigkeit der Taktfrequenz die Register TWSR und TWBR
'Der Befehl "Config Twi" setzt in Abhngigkeit der Taktfrequenz die Register
'TWSR und TWBR. Die Taktfrequenz der Slaves sollte mindestens das 16-fache der
'Busfrequenz betragen (Bus: 100 kHz - Takt: 1,6 MHz).
'Bei Adressierungsfehlern kann die Busfrequenz in bestimmten Grenzen reduziert
'werden. Noch geringere Busfrequenzen sind mglich, wenn die Taktfrequenz des
'MCs verringert wird.

   $lib "i2c_twi.lbx"                             'fr TWI Hardware
   Config Scl = Portc.0                           'Bussignal SCL
   Config Sda = Portc.1                           'Bussignal SDA
   Config Twi = 50000                             'Bustakt 50 kHz
   I2cinit                                        'auch nach PORT/DDR wichtig
   Waitms 500
'
'-------------------------------------------------------------------------------
'
A_142_timer:                                      'Editmarker: Timer
'
'Timer
'-----
'/// Achtung ///
' Fr den Betrieb mit einem DCF-Empfnger (Funkuhr) ist Timer 1 erforderlich.
' Eine Konfiguration ist nicht erforderlich.
'
'Normal-Konfiguration
' Die Interrupts der Timer werden beim jeweiligen Timerberlauf ausgelst.
' PSC: Vorteiler; TZW: Zhlwert; TVE: Voreinstellwert
' [mgliche Werte fr PSC: 1-8-64-256-1024]
'
'> Konfiguration bei einer Taktfrequenz von 8 MHz
'  T0: 0,001  s ( 1.000 Hz); 8-bit Zhler
'                                   PSC  TZW   T       f                   TVE
'  T0 = 1/ Quarz* Teiler (1/ 4 MHz*  64*  62 = 1,0 ms;  992 Hz) 256-  62 = 194
'  T0 = 1/ Quarz* Teiler (1/ 8 MHz*  64* 125 = 1,0 ms; 1000 Hz) 256- 125 = 131
'  T0 = 1/ Quarz* Teiler (1/16 MHz*  64* 250 = 1,0 ms; 1000 Hz) 256- 250 =   6
'
'  T0: 0,0001 s (10.000 Hz); 8-bit Zhler
'* T0 = 1/ Quarz* Teiler (1/ 8 MHz*   8* 156 = 0,1 ms; 10x3 Hz) 256- 99  = 157
'
'Systemzeit
'----------
' Timer 0: Voreinstellung auf Wert "TVE" und innerhalb der Interrupt-Routine
   Config Timer0 = Timer , Prescale = 8           'Konfiguration
      T0_tve = 156                                'TVE: Voreinstellwert
      Timer0 = T0_tve                             'Timer 0: Voreinstellung
'
'-------------------------------------------------------------------------------
'
A_142_lcd:                                        'Editmarker: LCD
'
'LCD
'---
'-LCD-Typ: 2 Zeilen, 16 Zeichen
   Config Lcd = 16 * 2
   Config Lcdpin = Pin , Db4 = Portc.4 , Db5 = Portc.5 , Db6 = Portc.6 , _
          Db7 = Portc.7 , E = Portc.3 , Rs = Portc.2
   Cls                                            'Anzeige lschen

A_143_dcf:                                        'Editmarker: DCF
'
'DCF-Modul
'---------
'Konfiguration des Funkempfanges (DCF77)
' - jeder digitale Eingang ist fr den Signaleingang mglich
' - Timer 1 ist erforderlich
'   Er steht daher fr individuelle Aufgaben nicht zur Verfgung.
' - das DCF-Unterprogramm muss den Namen "Sectic" tragen
   Config Dcf77 = Pind.7 , Timer = 1 , Check = 2 , Inverted = 1 , Gosub = Sectic

'Datumsformat festlegen
   Config Date = Dmy , Separator = Dot            'Format: TT.MM.JJ

A_144_adc:                                        'Editmarker: ADC
'
'Analog/Digital Konverter
'------------------------
'Zur Helligkeitssteuerung des Displays wird die Spannung ber den Analogeingang
'PA.7 am Pin 33 eingelesen, an dem ein Fototransistor anzuschlieen ist.
'Der Wert wird 1x in drei Sekunden ermittelt; die Abfrage erfolgt in der DCF-
'Routine.
'Es wird vom ADC immer ein Wert zwischen 0...1024 ausgegeben. Der Spannungs-
'wert errechnet sich aus dem Produkt der Konstanten (Vref/1024) und dem Mess-
'wert.
'
'-Prescaler (Frequenzteiler durch 2, 4, 8, 16, 32, 64, 128)
'-ADC bentigt eine Frequenz von 50-200 kHz
'-Modus <AUTO>: hchstmgliche Frequenz wird gewhlt
'-interne Referenzspannungsquelle (2,56 V) nutzen
'-ADC erst starten, wenn Programm in die Schleife kommt!
   Config Adc = Single , Prescaler = Auto , Reference = Internal
'
'-------------------------------------------------------------------------------
'
A_144_int:                                        'Editmarker: Interrupt
'
'Interrupt
'---------
   Enable Timer0                                  'Timer 0: Interrupt
      On Timer0 Int_tim0                          'Timer 0: berlauf (UP)
   Enable Int1                                    'PD.3 /Reset vom PRG
      On Int1 Int_reset
      Config Int0 = Rising
   Enable Interrupts
'
A_150_alias:                                      'Editmarker: Alias
'
'15. Alias
'---------
'Port A
'%

'Port B
'Eingang (digital)
'-----------------
   Tas Alias Pinb                                 'Tastenabfrage
'Ausgang (digital)
'-----------------
   Ton Alias Portb.4                              'Signalgeber

'Port C
'Eingang (digital)
'-----------------
'Ausgang (digital)
'-----------------
   Lcd_hel Alias Portd.4                          'LCD HGB (PWM)
   Lcd_kon Alias Portd.5                          'LCD Kontrast (PWM)

'Port D
'Eingang (digital)
'-----------------
'DCF (Funkuhr)
   Dcf Alias Pind.7                               'Pin 21: DCF-Signal

'Ausgang (digital)
'-----------------
'LED
   Led_rt Alias Portd.0                           'LED_rot
   Led_gn Alias Portd.1                           'LED_grn
   Led_bl Alias Portd.2                           'LED_blau
'
'-------------------------------------------------------------------------------
'
A_160_init:                                       'Editmarker: Initialisierung
'
'16. Initialisierung
'-------------------
A_161_konstante:                                  'Editmarker: Konstante
'
'Konstanten
'----------
   K_jth = 20                                     'DCF: Jahrtausend/Jahrhundert

   K_pa = 5                                       'Anzahl Programme
   K_mod = 20                                     'Anzahl Mode (Einstellungen)
   K_twi = 5                                      'Zeit zur Fehlerreduzierung

   K_azd = 800                                    'Anzeigedauer (Takt 10 ms)
   K_azh = 50                                     'LCD/ANZ Helligkeit (0: Aus)
   K_azk = 5                                      'LCD Kontrast   (0: Ein)
   K_azl = 5                                      'LED Helligkeit (0: Aus)

   K_slv = 8                                      'Slave-Anzahl im System

A_162_eeprom:                                     'Editmarker: EEprom
'
'EEprom
'------
   V_pa = E_pa                                    'PA: Programmauswahl
   If V_pa = 0 Or V_pa > K_pa Then
      V_pa = 1
      E_pa = V_pa                                 'Wert > EEprom
   End If

   V_ac = E_ac                                    'AC: Anzeigekontrast
   If V_ac = 0 Or V_ac > 20 Then
      V_ac = K_azk                                'Festwert beim Start
      E_ac = V_ac                                 'Wert > EEprom
   End If

   V_ah = E_ah                                    'AH: Anzeigehelligkeit
   V_kf = V_ah                                    'AH: Initialisierung
   If V_ah = 0 Or V_ah > 99 Then
      V_ah = K_azh                                'Festwert beim Start
      E_ah = V_ah                                 'Wert > EEprom
   End If

   V_lh = E_lh                                    'AL: Helligkeit LED
   If V_lh = 0 Or V_lh > 15 Then
      V_lh = K_azl                                'Festwert beim Start
      E_lh = V_lh                                 'Wert > EEprom
   End If

   V_sa = E_sa                                    'SA: Slaveanzahl
   If V_sa = 0 Or V_sa > K_slv Then
      V_sa = K_slv                                'Festwert beim Start
      E_sa = V_sa                                 'Wert > EEprom
   End If

   V_sh = E_sh                                    'SH: Helligkeitssteurung
   If V_sh > 1 Then                               '    per Sensor
      V_sh = 0
      E_sh = V_sh                                 'Wert > EEprom
   End If

   V_ea = E_ea                                    'EA: LCD-Anzeige JJ oder JJJJ
   If V_ea > 1 Then
      V_ea = 0
      E_ea = V_ea                                 'Wert > EEprom
   End If

'Ermittlung der letzen Slaveadresse
'25.01.2022
   M_slv = V_sa * 2 : M_slv = M_slv + &H20        'letzte Slave-Adress
'  M_slv = K_slv * 2 : M_slv = M_slv + &H20       'letzte Slave-Adress

'Lebenszeichen
'-------------
'Blinken beim Programmstart
   For Hz01 = 1 To 6
      Toggle F_gn                                 'LED_gn (3x)
      Waitms 300
   Next Hz01
   Hs_mor = "s" : Gosub Up_mor                    'Start-Tonausgabe "s" (...)

A_000_version:                                    'Editmarker: Version
A_163_version:                                    'Editmarker: Version
'
'Zeit von 4 s zur Synchronisation
   Call Cup_lcd( "Amatronik - UHR " , "Version: 1.1.30 " , 4)
'
'-------------------------------------------------------------------------------
'
'Erstinitialisierung
'/// Hinweis ///
'Wenn "Programm startet" in der Anzeige nicht erscheint, kann es daran liegen,
'dass in der Schaltung die Busabschluss-Widerstnde nicht aktiv sind.
   Cls
   Call Cup_lcd( "R-Abschluss an?" , "" , 0)
   Wait 1
   Cls

'Prfung der angeschlossenen Slaves
   For Hz01 = &H22 To M_slv Step 2                'Dezimal: 34 - 50
      Incr Hz02
      Select Case Hz02                            'Slave Zuordnung
         Case 1
            hs05 = "01-hh"
         Case 2
            hs05 = "02-mm"
         Case 3
            hs05 = "03-ss"
         Case 4
            Hs05 = "04-TT"
         Case 5
            hs05 = "05-MM"
         Case 6
            Hs05 = "06-J1"
         Case 7
            hs05 = "07-J2"
         Case 8
            Hs05 = "08-WT"
      End Select

M_sec_2:                                          'TWI-bertragung erst nach
      If F_sec = 0 Then                           'Interrupt durch DCF
         Waitms 50
         Goto M_sec_2
      Else
         Reset F_sec
      End If

      I2cstart                                    'TWI starten
         Waitms 100
         I2cwbyte Hz01                            'Slave ansprechen
      I2cstop                                     'TWI stoppen

'Anzeige und Signalausgabe
      Hs10 = " ADR..: --"
      Call Cup_lcd( "Slave: &D" + Str(hz01) , Hs05 + Hs10 , 0)
      Waitms 200

      If Err = 0 Then                             '<Err> auswerten
         Hs10 = " ADR..: ok"                      'Slave erkannt
         Hs_mor = "e"                             'Init Tonausgabe "e" (.)
      Else
         Hs10 = " ADR..: nc"                      'Slave nicht erkannt
         Hs_mor = "t"                             'Init Tonausgabe "m" (-)
      End If
'Anzeige &D (Dezimal)
      Call Cup_lcd( "Slave: &D" + Str(hz01) , Hs05 + Hs10 , 0)
      Gosub Up_mor                                'Tonausgabe
      Waitms 300

   Next Hz01
'
'-------------------------------------------------------------------------------
'20. === P R O G R A M M =======================================================
'-------------------------------------------------------------------------------
'
A_000_init:                                       'Editmarker: Initialisierung
A_210_init:                                       'Editmarker: Initialisierung
'
'Initialisierung
'---------------
   _sec = 0                                       'Uhr 00:00:
   M_mod = 1
   Hs_jt = "00"                                   'Datum Jahrtaused

A_000_programm:                                   'Editmarker: Programm
A_220_programm:                                   'Editmarker: Programm
'
Do
A_221_led:                                        'Editmarker: LED-Anzeige
'
'Steuerung der LED-Anzeige
   If F_dok = 1 Then                              'erste DCF-Empfang ok
'06.02.2022 - DCF-Fehleranzeige
'Wenn im Betrieb der DCF-Empfang ausfllt, wird die durch ein blaues Blitzen
'angezeigt.
'Bascom-Hilfe zum DCF-Fehlerbyte <status_bit.2>:
'Dieses Bit wird gesetzt, wenn nach einem vollstndigen Zeitstempel bei Sekunde
'58 der Zeitstempel geprft und in Ordnung ist. Wird nach einer Minutenmarke
'[2 Sek. Pause] dieses Bit gesetzt, wird die Uhrzeit aus dem DCF-Teil in den
'Clock-Teil kopiert und auch dieses Bit zurckgesetzt. Jede zweite Marke setzt
'dieses Bit ebenfalls zurck. Die Zeit ist also erst gesetzt, wenn nach Sekunde
'58 eine Minutenmarke folgt.
'Normalerweise ist dieses Bit nur von Sekunde 58 bis Sekunde 60/00 auf dem
'Wert 1.

'Fr eine Auswertung erfolgt die Abfrage dreimal hintereinander und erst dann
'wird ggf. das Fehlerbit <F_dsa> gesetzt.
      If F_dpr = 1 Then                           'Prfung aktiv
         Reset F_dpr
         If _sec = 50 And Dcf_status.2 = 1 Then   'Status falsch
            Incr Z_dcf
         End If
         If _sec = 59 And Dcf_status.2 = 0 Then   'Status falsch
            Incr Z_dcf
         End If
         If _sec = 59 And Dcf_status.2 = 1 Then   'Status ok
            Z_dcf = 0
         End If
         If Z_dcf > 3 Then Z_dcf = 3              'Begrenzung
      End If

      If Z_dcf = 3 Then                           'Fehler wird signalisiert
          Set F_dsa
          Reset F_rt : Reset F_gn : Reset F_bl
          Goto M_led
      Else
         Reset F_dsa
      End If

      Select Case V_pa
         Case 1                                   'Normalzeit
            Select Case Utc_mez
               Case 1                             'Farbe: gelb (MEZ)
                  Set F_rt : Set F_gn : Reset F_bl
               Case 2                             'Farbe: grn (MESZ)
                  Reset F_rt : Set F_gn : Reset F_bl
            End Select
         Case 2                                   'UTC
            Set F_rt : Reset F_gn : Set F_bl      'Farbe: magenta
         Case Else                                'Zusatzinformationen
            Set F_rt : Reset F_gn : Reset F_bl    'Farbe: wei
      End Select
   End If
M_led:

A_222_bedienung:                                  'Editmarker: Bedienung
'
' Tastenauswertung
   Gosub Up_tas

' So lange, wie eine Taste bettigt ist, erfolgt eine Tastenauswertung.
' Ohne gedrckte Taste erfolgt ein Rcksprung zur Zeitanzeige nach 5 Sekunden,
' was ber Timer 0 gesteuert wird.
   If F_tas = 1 Then                              'Tastenbedienung erkannt
      Reset F_tas
      Set F_as                                    'Anzeige aus
      T_azd = 0                                   'Reset Zhler Anzeigezeit

'Anzeige lschen
' Dazu wird jedem angesschlossenen Slave der Wert "Z" zugewiesen.
      If T_wer = 1 Then
         Gosub Up_del
      End If

'Auswertungen der Tasten
'-----------------------
' 1: PA - Einstellung des Anzeigeformates (MEZ, MESZ, UTC) bzw.
'         Zusatzinformationen ber das System
'         3: ADC (Sensorwert)
'         4: PWM (Anzeige-Helligkeit)
' 2: AC - Einstellung LCD-Kontrast
' 3: AH - Einstellung Helligkeit fr LCD und Digitalanzeige
' 4: LH - LED-Helligkeit (Status-LED)
' 5: SA - Einstellung der Slaveanzahl
' 6: SH - Steuerung der Helligkeit ber den Sensor (Ein/Aus)   1)
' 7: EA - Einstellung der LCD-Anzeige (JJ oder JJJJ)

'11: H- - Einstellung der Stunden Zehner
'12: -H - Einstellung der Stunden Einer
'13: M- - Einstellung der Minuten Zehner
'14: -M - Einstellung der Minuten Einer
'15: S- - Einstellung der Sekunden Zehner
'16: -S - Einstellung der Sekunden Einer

'%%: [] - (nicht belegt)

'1) Beim Einsatz der internen Referenzspannung von 2,56 V ergibt sich bei einem
'   Wertebereich von 0-1023 fr den ADC eine Teilspannung von 2,56 mV.
'   Da durch das Programm Werte ber 200 zur PMW-Steuerung der Anzeige genutzt
'   werden, ist ber das Potentiometer ein Wert vonn 200 bei vlliger Dunkel-
'   heit einzustellen, was einem Spannungswert von 200x 2,56 mV= 0,512 V ent-
'   spricht.

      Select Case T_wer
'Die Reaktion ist vom aktiven Modus abhngig.
'Taste 1 - Umschaltung Modus
         Case 1
'Anzeige Modus ber Slave &H22
            If F_sta = 0 Then                     '1. Durchlauf ohne INCR
               Set F_sta
            Else
               Incr M_mod
            End If

            If M_mod > K_mod Then
               M_mod = 1
            End If

            Slv_adr = &H22
            Slv_wer = M_mod + 100                 'maximal bis 127 mglich
            Gosub Up_twi_tx                       'Datenbetragung Modus

'Berechnung nur, wenn erforderlich
            If M_mod > 10 And M_mod < 17 Then
               Set F_ze                           'Zeiteinstellung
               T_azd = 0                          'Anzeigezeit verlngern
'Werte fr Stunden
               V_z1 = _hour / 10
               V_hz = Int(v_z1)
               V_z2 = V_hz * 10
               V_z1 = _hour
               V_he = V_z1 - V_z2
'Werte fr Minuten
               V_z1 = _min / 10
               V_mz = Int(v_z1)
               V_z2 = V_mz * 10
               V_z1 = _min
               V_me = V_z1 - V_z2
'Werte fr Sekunden
               V_z1 = _sec / 10
               V_sz = Int(v_z1)
               V_z2 = V_sz * 10
               V_z1 = _sec
               V_se = V_z1 - V_z2
            End If

            Select Case M_mod                     'Modus
'Anzeige Modus-Wert ber Slave &H24
               Case 1                             'PA
                  Slv_wer = V_pa
               Case 2                             'AC
                  Slv_wer = V_ac
               Case 3                             'AH
                  Slv_wer = V_ah
               Case 4                             'LH
                  Slv_wer = V_lh
               Case 5                             'SA
                  Slv_wer = V_sa
               Case 6                             'SH
                  Slv_wer = V_sh
               Case 7                             'EA
                  Slv_wer = V_ea

'Zeiteinstellung
               Case 11 To 12                      'H-/-H: Stunden Zehner/Einer
                  Slv_wer = V_hz * 10
                  Slv_wer = Slv_wer + V_he
               Case 13 To 14                      'M-/-M: Stunden Zehner/Einer
                  Slv_wer = V_mz * 10
                  Slv_wer = Slv_wer + V_me
               Case 15 To 16                      'S-/-S: Stunden Zehner/Einer
                  Slv_wer = V_sz * 10
                  Slv_wer = Slv_wer + V_se
            End Select

'Anzeige Moduswert
            Slv_adr = &H24
            Gosub Up_twi_tx

'Taste 2 - Wert verringern
         Case 2
            Select Case M_mod
'Programmauswahl
               Case 1
                  Decr V_pa
                  If V_pa = 0 Then
                     V_pa = K_pa
                  End If
                  E_pa = V_pa
                  Slv_wer = V_pa
'LCD Kontrast
               Case 2
                  Decr V_ac
                  If V_ac = 0 Then
                     V_ac = K_azk
                  End If
                  E_ac = V_ac
                  Slv_wer = V_ac
'Anzeige Helligkeit
               Case 3
                  Decr V_ah
                  If V_ah = 0 Then
                     V_ah = K_azh
                  End If
                  E_ah = V_ah
                  Slv_wer = V_ah
'29.01.2022 - direkte nderung bei der Anzeige
                  V_kf = V_ah
'LED Helligkeit
               Case 4
                  Decr V_lh
                  If V_lh = 0 Then
                     V_lh = K_azl
                  End If
                  E_lh = V_lh
                  Slv_wer = V_lh
'Slaveanzahl
               Case 5
                  Decr V_sa
                  If V_sa = 0 Then
                     V_sa = K_slv
                  End If
                  E_sa = V_sa
                  Slv_wer = V_sa
'Steuerung Helligkeit
               Case 6
                  If V_sh = 1 Then
                     V_sh = 0
                  End If
                  E_sh = V_sh
                  Slv_wer = V_sh
'Einstellung Anzeige LCD
               Case 7
                  If V_ea = 1 Then
                     V_ea = 0
                  End If
                  E_ea = V_ea
                  Slv_wer = V_ea
'Zeiteinstellung
' Stunden
               Case 11                            'h-: Zehner verringern
                  If V_hz > 0 Then
                     Decr V_hz
                  Else
                     V_hz = 2
                  End If
                  If V_hz = 2 And V_he > 3 Then
                     V_he = 3                     'Begrenzung auf 23
                  End If
                  V_z1 = V_hz * 10
                  Slv_wer = V_z1 + V_he
                  _hour = Slv_wer

               Case 12                            'h-: Einer verringern
                  If V_he > 0 Then
                     Decr V_he
                  Else
                     If V_hz = 2 Then             'Begrenzung auf 23
                        V_he = 3
                     Else
                        V_he = 9
                     End If
                  End If
                  V_z1 = V_hz * 10
                  Slv_wer = V_z1 + V_he
                  _hour = Slv_wer
'Zeiteinstellung
' Minuten
               Case 13                            'm-: Zehner verringern
                  If V_mz > 0 Then
                     Decr V_mz
                  Else
                     V_mz = 5
                  End If
                  V_z1 = V_mz * 10                'Zehner
                  Slv_wer = V_z1 + V_me
                  _min = Slv_wer

               Case 14                            'm-: Einer verringern
                  If V_me > 0 Then
                     Decr V_me
                  Else
                     V_me = 9
                  End If
                  V_z1 = V_mz * 10                'Zehner
                  Slv_wer = V_z1 + V_me
                  _min = Slv_wer
'Zeiteinstellung
' Sekunden
               Case 15                            's-: Zehner verringern
                  If V_sz > 0 Then
                     Decr V_sz
                  Else
                     V_sz = 5
                  End If
                  V_z1 = V_sz * 10                'Zehner
                  Slv_wer = V_z1 + V_se
                  _sec = Slv_wer

               Case 16                            's-: Einer verringern
                  If V_se > 0 Then
                     Decr V_se
                  Else
                     V_se = 9
                  End If
                  V_z1 = V_sz * 10                'Zehner
                  Slv_wer = V_z1 + V_se
                  _sec = Slv_wer
            End Select

'Anzeige Einstellwert
            Slv_adr = &H24
            Gosub Up_twi_tx                       'Anzeige Einstellwert

'Taste 3 - Wert erhhen
         Case 3
            Select Case M_mod
'Programmauswahl
               Case 1
                  Incr V_pa
                  If V_pa > K_pa Then
                     V_pa = 1
                  End If
                  E_pa = V_pa
                  Slv_wer = V_pa
'LCD Kontrast
               Case 2
                  Incr V_ac
                  If V_ac > 20 Then
                     V_ac = K_azk
                  End If
                  E_ac = V_ac
                  Slv_wer = V_ac
'Anzeige Helligkeit
               Case 3
                  Incr V_ah
                  If V_ah > 99 Then
                     V_ah = K_azh
                  End If
                  E_ah = V_ah
                  Slv_wer = V_ah
'29.01.2022 - direkte nderung bei der Anzeige
                  V_kf = V_ah
'LED Helligkeit
               Case 4
                  Incr V_lh
                  If V_lh > 20 Then
                     V_lh = K_azl
                  End If
                  E_lh = V_lh
                  Slv_wer = V_lh
'Slaveanzahl
               Case 5
                  Incr V_sa
                  If V_sa > 10 Then
                     V_sa = K_slv
                  End If
                  E_sa = V_sa
                  Slv_wer = V_sa
'Steuerung Helligkeit
               Case 6
                  If V_sh = 0 Then
                     V_sh = 1
                  End If
                  E_sh = V_sh
                  Slv_wer = V_sh
'Steuerung Helligkeit
               Case 7
                  If V_ea = 0 Then
                     V_ea = 1
                  End If
                  E_ea = V_ea
                  Slv_wer = V_ea
'Zeiteinstellung
' Stunden
               Case 11                            'h-: Zehner  erhhen
                  If V_hz < 2 Then
                     Incr V_hz
                  Else
                     V_hz = 0
                  End If
                  If V_hz = 2 And V_he > 3 Then   'Einerbegrenzung bei 23
                     V_hz = 3
                  End If
                  V_z1 = V_hz * 10                'Zehner
                  Slv_wer = V_z1 + V_he
                  _hour = Slv_wer

               Case 12                            'h-: Einer  erhhen
                  If V_hz < 2 Then
                     If V_he < 9 Then
                        Incr V_he
                     Else
                        V_he = 0
                     End If
                  Else
                     If V_he < 3 Then             'Einerbegrenzung bei 23
                        Incr V_he
                     Else
                        V_he = 0
                     End If
                  End If
                  V_z1 = V_hz * 10                'Zehner
                  Slv_wer = V_z1 + V_he
                  _hour = Slv_wer
'Zeiteinstellung
' Minuten
               Case 13                            'm-: Zehner  erhhen
                  If V_mz < 5 Then
                     Incr V_mz
                  Else
                     V_mz = 0
                  End If
                  V_z1 = V_mz * 10                'Zehner
                  Slv_wer = V_z1 + V_me
                  _min = Slv_wer

               Case 14                            'm-: Einer  erhhen
                  If V_me < 9 Then
                     Incr V_me
                  Else
                     V_me = 0
                  End If
                  V_z1 = V_mz * 10                'Zehner
                  Slv_wer = V_z1 + V_me
                  _min = Slv_wer
'Zeiteinstellung
' Sekunden
               Case 15                            's-: Zehner erhhen
                  If V_sz < 5 Then
                     Incr V_sz
                  Else
                     V_sz = 0
                  End If
                  V_z1 = V_sz * 10                'Zehner
                  Slv_wer = V_z1 + V_se
                  _sec = Slv_wer

               Case 16                            's-: Einer  erhhen
                  If V_se < 9 Then
                     Incr V_se
                  Else
                     V_se = 0
                  End If
                  V_z1 = V_sz * 10                'Zehner
                  Slv_wer = V_z1 + V_se
                  _sec = Slv_wer
            End Select

'Anzeige Einstellwert
            Slv_adr = &H24
            Gosub Up_twi_tx                       'Anzeige Einstellwert
      End Select
'Whren der Bedienung wird keine Zeit angezeigt. Erst nach max. 5 s erfolgt die
'automatische Umschaltung.
      M_wer = T_wer                               'Tastenwert merken
   End If

   If F_as = 1 Then                               'Anzeige ist aus
'Zeile 1
      Select Case M_mod
         Case 1 To 7
            Hs16 = Lookupstr(m_mod , Modus )
         Case 11 To 16
            Hs16 = Lookupstr(8 , Modus )
         Case Else
            Hs16 = Lookupstr(0 , Modus )
      End Select
      Locate 1 , 1 : Lcd Hs16
'Zeile 2
      Select Case M_mod
         Case 1
            Hs16 = Str(v_pa)
         Case 2
            Hs16 = Str(v_ac)
         Case 3
            Hs16 = Str(v_ah)
         Case 4
            Hs16 = Str(v_lh)
         Case 5
            Hs16 = Str(v_sa)
         Case 6
            Hs16 = Str(adc_k7)
            While Len(hs16) < 3                   'Format "###'
               Hs16 = " " + Hs16
            Wend
            If V_sh = 1 Then                      'Anzeige bei Ein
               Hs16 = "Sensorwert: " + Hs16 + " "
            Else
               Hs16 = "(Sensor inaktiv)"          'Anzeige bei Aus
            End If
         Case 7
            Hs16 = "Jahr: JJ JJJJ"
         Case Else
            Hs16 = Lookupstr(0 , Modus )
      End Select

      While Len(hs16) < 16                        'Format "###'
         Hs16 = Hs16 + " "
      Wend
      Locate 2 , 1 : Lcd Hs16

      Goto M_end
   End If

A_223_dcf:                                        'Editmarker: DCF
'
'DCF
'---
M_dcf:
   Gosub Up_dcf                                   'DCF (Fehler)
'Ermittlung der Zeitanzeige
' Wochentag
   Hs_wt = Lookupstr(utc_wt , Wochentag)
   Select Case V_ea                               'LCD-Anzeige JJ oder JJJJ
      Case 0                                      'Anzeige Datum: TT:MM:JJ
'06.02.2022
         Hs_da = Date$ + "        "
      Case 1                                      'Anzeige Datum: TT:MM:JJJJ ---
         Hs_da = Left(date$ , 6) + Hs_jt + Right(date$ , 2) + "      "
   End Select

   If F_dok = 1 Then                              'DCF war einmal ok
      If F_err = 0 And Z_dcf = 0 Then
            Hs_jt = "20"
            Select Case V_ea                      'LCD-Anzeige JJ oder JJJJ
               Case 0
                  Hs_zt = " " + Hs_wt + "  DCF"   'kein DCF-Fehler
               Case 1
                  Hs_zt = "  " + Hs_wt + " DCF"   'kein DCF-Fehler
            End Select
      Else
            Hs_zt = " " + Hs_wt + " Err "         'DCF-Fehler
      End If
   Else
      Hs_zt = "     ---"                          'Anzeige Zeit:  hh:mm:ss ---
   End If

'08.02.2022 - Anzeige von Zusatzinformationen
   Select Case V_pa
      Case 1
         Hs03 = "   "
      Case 2                                      'Anzeige der UTC-Zeit
         Hs03 = "UTC"
      Case 3
         Hs03 = Str(adc_k7)                       'ADC (Sensorwert)
      Case 4
         Hs03 = Str(v_kf)                         'PWM (Anzeige-Helligkit)
   End Select

   While Len(hs03) < 3                            'Format "###'
      Hs03 = " " + Hs03
   Wend
   Hs_da = Left(hs_da , 13) + Hs03

A_224_daten:                                      'Editmarker: Datenbertragung
'
'Datenbertragung
'----------------
   If F_sec = 1 And F_ze = 0 Then                 'Aufruf je s
      Reset F_sec
      Gosub Up_sec

      Select Case V_pa                            'Programmauswahl
'Steuerung LCD und der kompletten Digitalanzeige (hh:mm:ss TT.MM.JJJJ WT)
'1: Normalzeit MES/MESZ
'2: Zeitangabe UTC
'3: Zusatzinformation 1 - ADC (Sensorwert)
'4: Zusatzinformation 2 - PWM (Anzeige-Helligkit)
'5: %
         Case 1 To 5
            Call Cup_lcd(time$ + Hs_zt , Hs_da , 0)
'Slave &H26-38 - Sekunde (ss)
            Slv_adr = &H26
            Slv_wer = Utc_sec                     'Sekunde (UTC)
            Gosub Up_twi_tx
'Slave &H22-34 - Stunde (hh)
            If _sec = 0 Or F_us = 1 Then
               Reset F_us
               Slv_adr = &H22
               Slv_wer = Utc_hour                 'Stunde (UTC)
               Gosub Up_twi_tx
'Slave &H24-36 - Minute (mm)
               Slv_adr = &H24
               Slv_wer = Utc_min                  'Minute (UTC)
               Gosub Up_twi_tx
'Slave &H28-40 - Tag (TT)
               Slv_adr = &H28
               Slv_wer = Utc_day                  'Tag (UTC)
               Gosub Up_twi_tx
'Slave &H2A-42 - Monat (MM)
               Slv_adr = &H2A
               Slv_wer = Utc_month                'Monat (UTC)
               Gosub Up_twi_tx
               Slv_adr = &H2C
'Die komplette Jahresanzeige erfolgt erst, wenn ein Jahr zur Verfgung steht.
               If _year > 0 Then
                  Slv_wer = K_jth                 'Jahr 20xx
               Else
                  Slv_wer = 0
               End If
               Gosub Up_twi_tx
'Slave &H2E-46 - Jahr 2 (xxJJ)
               Slv_adr = &H2E
               Slv_wer = Utc_year                 'Jahr 10/1 (UTC)
               Gosub Up_twi_tx
'Slave &H30-48 - Wochentag (WT)
               Slv_adr = &H30
               Slv_wer = Utc_wt                   'Wochentag (UTC)
               Gosub Up_twi_tx
            End If

'Steuerung Slaves 1, 2 (hh:mm)
         Case 3

      End Select
   End If

A_225_helligkeit:                                 'Editmarker: Anzeigehelligkeit
'
'Helligkeitssteuerung
'--------------------
   If V_sh = 1 Then                               'HGB-Steuerung per Sensor
' Sensorspannung einlesen (1x in 3 Sekunden)
      If F_hgb = 1 And F_sec = 0 Then
         Reset F_hgb
         Start Adc
            Adc_sen = Getadc(7)
            Waitms 20
            Adc_sen = Adc_sen + Getadc(7)
         Stop Adc
' Festlegung der HGB-Leuchtdauer
         Shift Adc_sen , Right , 1                'Mittelwert
         Adc_k7 = Adc_sen                         'Wert fr LCD-Anzeige
         Select Case Adc_sen
            Case Is < 201
               Kf_ah = 0
            Case 201 To 300                       'Rest >= 1
               Kf_ah = Adc_sen - 200              'LCD-Wert mit Poti auf 200 bei
               Kf_ah = Kf_ah * 4                  'abgedeckten FT einstellen
            Case Is > 300
               Kf_ah = 99                         'bei bersteuerung
         End Select
'07.02.2022 - allmhlicher Helligkeitswechsel
            V_hel = V_ah + Kf_ah                  'Grundhelligkeit + nderung
            If V_hel > 99 Then V_hel = 99         'Begrenzung

            If V_hel < 10 And V_kf > V_ah Then
               Decr V_kf : Goto M_hel
            End If

            If V_kf < V_hel And V_hel > 10 Then
               Incr V_kf                          'Anpassung Helligkeit
            End If

            If V_kf > V_hel Then
               Decr V_kf                          'Anpassung Helligkeit
            End If
         End If
M_hel:
         If V_kf > 99 Then
            V_kf = 99
         End If
   Else
'29.01.2022 - Einstellung der Grundhelligkeit im Modus ohne Sensorsteuerung
      V_kf = V_ah
   End If

M_end:
'Ende Programmschleife
Loop

'Ende Programm
End
'
'===============================================================================
'
A_300___interrupt:                                'Editmarker: Interrupt
'
'-------------------------------------------------------------------------------
'30. === I N T E R R U P T R O U T I N E =======================================
'-------------------------------------------------------------------------------
'
A_310_int_t0:                                     'Editmarker: INT T0
'
' /// Achtung ///
' Der Timer 1 ist fr die Funkuhr (DCF) reserviert.
'
'Timer 0
'-------
'Timer 0 dient als allgemeiner Taktgeber.
'
Int_tim0:
'Timer-Interrupt: 100 s
   Timer0 = T0_tve                                'Voreinstellung des Zhlers
   Incr Z_led                                     'Zeitbasis 0,1 ms
   Incr Z_kon                                     'Zeitbasis 0,1 ms
   Incr Z_hel                                     'Zeitbasis 0,1 ms

'Mit einem anderen Endwert kann die Anzahl der Schritte fr den Kontrast oder
'die Hintergrundhelligkeit des LCDs verndert werden.
'Zeitbasis: 100 s
   If Z_kon = 50 Then                             'Zhler  5 ms
      Z_kon = 0                                   'Zhler Kontrast
   End If

   If Z_hel = 100 Then                            'Zhler 10 ms
      Z_hel = 0
'Der Zhler fr die Umschaltzeit ist nur bei einer Bedienung aktiviert.
      If F_as = 1 Then
         Incr T_azd                               'Zeitdauer Anzeige [s]
      End If
   End If

   If Z_led = 200 Then                            'Zhler 20 ms
      Z_led = 0
   End If

'Zeitverschiebung
   If Z_led = 20 Then Incr T_dcf
   If Z_hel = 70 Then Incr T_hgb                  'Zeit Steuerung Helligkeit

   If T_hgb = 300 Then                            'Abfrage ADC 1x in 3 s
      T_hgb = 0
      Set F_hgb
   End If

'06.02.2022 - DCF-Ausfall
'Anzeige des Signalausfalls durch eine blitzende blaue LED
   If F_dsa = 1 Then
      Reset F_bl
      Select Case T_dcf
         Case Is < 5
            Set F_bl
         Case 150
            T_dcf = 0
      End Select
   End If

'Umschaltung von Bedienung auf Zeitanzeige
   If T_azd >= K_azd Then                         'Zeitdauer Anzeige [s]
      T_azd = 0
      M_wer = 0                                   'Merker Tastenwert= 0
      M_mod = 1
      Set F_us                                    'Anzeige soll umschalten
      Reset F_as                                  'Anzeigesperrezeit
      Reset F_sta
      Reset F_ze                                  'Zeiteinstellung
   End If

'PWM-Steuerung Anzeige
'---------------------
'Kontrast (LCD) - Eine lngere Einschaltzeit bedeutet eine hhere Spannung
'                 und damit einen geringeren Kontrast des LCDs.
'Helligkeit     - Ein lngerer PWM-Einschaltwert bedeutet eine hellere Hinter-
'                 grundbeleuchtung beim LCD bzw. der Leuchtstrke der Digits.
'LED            - Ein lngerer PWM-Einschaltwert bedeutet eine hellere LED

   If Z_kon = 0 Then
      Set Lcd_kon                                 'Kontrast: Ein
   End If

   If Z_hel = 0 Then
      Set Lcd_hel                                 'Helligkeit: Ein
   End If

'Farben der Anzeige-LED entsprechend einschalten
   If Z_led = 0 Then
'02.02.2022
      Led_rt = F_rt                               'Helligkeit: Ein
      Led_gn = F_gn                               'Helligkeit: Ein
      Led_bl = F_bl                               'Helligkeit: Ein
   End If

'02.02.2022 - Vergleich von >= in = gewandelt
   If Z_kon = V_ac Then Reset Lcd_kon             'Kontrast LCD ......... : Aus
   If Z_hel = V_kf Then Reset Lcd_hel             'Helligkeit Anzeige ... : Aus
   If Z_led = V_lh Then Gosub Up_led              'Status LED ........... : Aus

Int0_ret:
Return

A_320_int_int1:                                   'Editmarker: INT1
'
'Wenn das Reset-Signal vom PRG-Gert beendet ist (steigende Flanke), wird der
'MC neu gestartet.
Int_reset:
   Goto 0                                         'Neustart

Int_reset_ret:
Return

A_400___up_gosub:                                 'Editmarker: UP Gosub
'
'-------------------------------------------------------------------------------
'40. === U N T E R P R O G R A M M - G O S U B =================================
'-------------------------------------------------------------------------------
A_410_upmor:                                      'Editmarker: UPG10
'
'Tonausgabe
'----------
Up_mor:
'Wandlung in ASCII
   Hs_mor = Ucase(hs_mor)                         'Zeichen gro
   Hm_mc = Asc(hs_mor)

   Select Case Hm_mc
      Case 0                                      'Pause 100 ms
         Waitms 100
         Goto Upmor_ret                           'Return
      Case Is < 58
         Hm_mc = Hm_mc - 48                       'Index ist nullbasiert
         Hs_mor = Lookupstr(hm_mc , Mc_zah)       'Morsecode Zahlen
      Case Else
         Hm_mc = Hm_mc - 65                       'Index ist nullbasiert
         Hs_mor = Lookupstr(hm_mc , Mc_buc)       'Morsecode Buchstaben
    End Select

   For Hz_mz = 1 To Len(hs_mor)
      Hs01 = Mid(hs_mor , Hz_mz , 1)

      If Hs01 = "." Then
         Set Ton : Waitms 70
      Else
         Set Ton : Waitms 210
      End If

      Reset Ton
      Waitms 70
   Next Hz_mz

Upmor_ret:
Return

A_420_updcf:                                      'Editmarker: UPG20
'
'DCF-Statusabfrage
'-----------------
'Fehlererkennung
' Bit 4 - H: DCF-Teil hat gestoppt
' Bit 7 - L: keine Synchronisation
Up_dcf:
   If Dcf_status.4 = 1 Or Dcf_status.7 = 0 Then   'Flag: Error
      Set F_err
      If F_dok = 0 Then
         F_bl = Not Dcf                           'LED laut DCF-Signal
      End If
   Else
      Reset F_err
      Set F_dok                                   'DCF erste Mal ok
   End If

Return

A_430_uptas:                                      'Editmarker: UPG30
'
'Abfrage der Tasten
'------------------
'Fr die Eingabe sind bis zu 9 Tasten vorhanden.
Up_tas:
   If F_tas = 1 Then                              'Auswertung noch nicht erfolgt
      Goto Return_tas                             'Abbruch der Routine
   Else
      T_zei = 0                                   'Reset Tastendruckzeit
      T_wer = 0
'Prfung auf Tastendruck
M_t01:
      T_cod = Tas And &H0F                        'Port B & 0000_1111: xxxx_DCBA
      If T_cod = &H0F Then                        'kein Tastendruck
         Goto M_t99                               'Return
'Tastendruck
      Else
         Waitms 20                                'Entprellzeit
         If T_wer <> T_cod Then
            Set Ton : Waitms 5 : Reset Ton        '1x Tastenklick (5 ms)
         End If
         T_wer = T_cod                            'Tastenwert 0000_DCBA
      End If
      Waitms 100
      T_cod = Tas And &H0F                        'Port B & 0000_1111: xxxx_DCBA
      If T_wer = T_cod Then                       'Taste noch gedrckt
         Incr T_zei                               'Zhler fr Tastendruckzeit
         If T_zei > 10 Then                       'Begrenzung auf 10
            T_zei = 10
         End If
         Goto M_t01                               'Tastenabfrage
      End If
      T_wer = Not T_wer                           'Wertanpassung
      T_wer = T_wer And &H0F                      'nur Bit 0-3
      Set F_tas                                   'Flag Auswertung
      T_cod = 0
M_t99:
   End If

Return_tas:
Return

A_440_upled:                                      'Editmarker: UPG40
'
'LED-Ausschaltung
'----------------
'Ausschalten aller drei Farben der RGB-LED
Up_led:
   Reset Led_rt : Reset Led_gn : Reset Led_bl

Return

A_450_updel:                                      'Editmarker: UPG50
'
'Anzeige lschen
'---------------
'Jedem Slave wird der Wert "Z" zugewiesen. In diesem Fall wird kein Segment
'angesteuert.
Up_del:
   For Hz01 = &H22 To M_slv Step 2                'Slave whlen
      Slv_adr = Hz01
      Slv_wer = 100                               'Wert fr "Anzeige aus"
      Gosub Up_twi_tx
   Next Hz01

Return

A_460_uptwi:                                      'Editmarker: UPG60
'
'Daten an die Slaves senden
'--------------------------
Up_twi_tx:
  Slv_prf = Slv_wer : Shift Slv_prf , Left , 1    'Prfwert erstellen
  I2cstart
     Waitms 10                                    'Wartezeit
     I2cwbyte Slv_adr                             'Slave Adresse
     I2cwbyte Slv_adr                             'Auswertung bei CQ (an alle)
     I2cwbyte Slv_wer                             'Wert > Slave
     I2cwbyte Slv_prf                             'Prfwert > Slave
  I2cstop

Return

A_470_sectic:                                     'Editmarker: UPG70
'
'DCF-Auswertung
'--------------
'Das UP wird durch den DCF-Timer automatisch jede Sekunde einmal aufgerufen;
'Die Variablen <$Time> und <Date$> werden zu diesem Zeitpunkt aktualisiert.
' /// Achtung ///
' Die Routine "Sectic" wird durch die in BASCOM integrierte Routine zur DCF-
' Auswertung je Sekunde einmal aufgerufen.
' Festgestellt wurde, dass es in unregelmigen Abstnden zu zeitlichen Abwei-
' chungen kommt. Dies tritt besonders dann auf, wenn sich die interne Uhr noch
' nicht mit der DCF-Zeit synchronisiert hat.

Sectic:
   Reset Watchdog                                 'Programm-Laufzeitberwachung
   Set F_sec                                      'Flag sectic
   Set F_dpr                                      'Set Statusprfung
'   Set F_hel                                      'Steuerung Anzeigehelligkeit

Return

'02.02.2022 - Verlagerung der Sectic-Routine
Up_sec:
   Utc_sec = _sec
   Utc_min = _min
   Utc_hour = _hour
   Utc_day = _day
   Utc_month = _month
   Utc_year = _year
   Utc_wt = Dayofweek() + 1                       'Wochentag (Zahl)
   Utc_mez = Dcf77timezone()                      '0: kein DCF 1: MEZ, 2: MESZ

'Wenn noch kein Datum fr den vergangenen Tag eingetragen ist, wird bei der
'ersten korrekten DCF-Zeit dieses eingetragen.
'Ansonsten erfolgt dies zum UTC-Tageswechsel.
   If F_wt = 0 And F_dok = 1 Then
      Set F_wt
      Old_day = Utc_day
      Old_month = Utc_month
      Old_year = Utc_year
      Old_wt = Utc_wt
   End If

   If F_wt = 1 And Utc_mez > 0 And _hour = Utc_mez And _min = 0 And _
                                   _sec = 0 Then
      Old_day = Utc_day
      Old_month = Utc_month
      Old_year = Utc_year
      Old_wt = Utc_wt
   End If

'Fr die UTC-Zeitangabe wird die Sekundendifferenz als Grundlage verwendet.
'Dazu werden die Funktionen der DateTime-Bibliothek eingesetzt.
'Ermittlung der aktuellen Tages-Sekunden
'Der Wert liegt im Bereich von 0 bis 86399 bei der Zeit 00:00:00 to 23:59:59.
'Ohne Eintrag werden <_sec>, <_min> und <_hour> ausgelesen.
   Tag_sec = Secofday()
   Hm_sec = Utc_mez * 3600                        '<Utc_mez>: 1 oder 2
   Hm_tim = 86400 - Hm_sec                        'Sekunden Vortag
   Bsec = Time(hm_sec)                            '<Bsec>, <Bmin>, <Bhour>

   Select Case V_pa
      Case 1                                      'Normalzeit MEZ/MESZ
'Dafr sind keine nderungen der Anzeige erforderlich.
      Case 2                                      'Zeitangabe UTC
'Ist noch keine DCF-Synchronisation erfolgt, werden hh:mm:ss angezeigt.
         If F_dok = 0 Then
            Utc_sec = _sec
            Utc_min = _min
            Utc_hour = _hour - Utc_mez            'Anzeige sofort ok
            Goto M_utc
         End If

'Je nach MEZ/MESZ sind die Korrekturwerte fr die Zeitanzeige zu bergeben.
         If Tag_sec < Hm_sec Then
'Anzeigewerte beim Datumswechsel
            Utc_sec = Bsec                        'Sekunde
            Utc_min = Bmin                        'Minute
            Utc_hour = Bhour                      'Stunde
            Utc_day = Old_day                     'Tag
            Utc_month = Old_month                 'Monat
            Utc_year = Old_year                   'Jahr
            Decr Utc_wt                           'Wochentagsanzeige
         Else
'Anzeigewerte beim Normalbetrieb
            Tag_sec = Tag_sec - Hm_sec
            Bsec = Time(tag_sec)
            Utc_sec = Bsec                        'Sekunde
            Utc_min = Bmin                        'Minute
            Utc_hour = Bhour                      'Stunde
         End If
M_utc:
      End Select

Return

A_500___up_call:                                  'Editmarker UP Call
'
'-------------------------------------------------------------------------------
'50. === U N T E R P R O G R A M M - C A L L ===================================
'-------------------------------------------------------------------------------
A_510_lcd:                                        'Editmarker UPC10
'
'LCD-Ausgabe
'-----------
Sub Cup_lcd(lcd_z1 As String , Lcd_z2 As String , Lcd_time As Byte)
'Prfen, ob sich die Anzeige gendert hat
   If Lcd_z1 <> Lcd_alt1 Or Lcd_z2 <> Lcd_alt2 Then

      Locate 1 , 1 : Lcd Lcd_z1                   'Ausgabe Zeile 1
      Locate 2 , 1 : Lcd Lcd_z2                   'Ausgabe Zeile 2

      Lcd_alt1 = Lcd_z1
      Lcd_alt2 = Lcd_z2

      If Lcd_time = 0 Then                        'Erforderlich, weil Wait 0
         Waitus 5                                 'zum Stillstand fhrt
      Else
         Wait Lcd_time
         Lcd_time = 0                             'Anzeigedauer 1x
      End If
   End If

End Sub

A_600___slaveinit:
'
'-------------------------------------------------------------------------------
'60. === I N I T I A L I S I E R U N G   D E R   S L A V E S ===================
'-------------------------------------------------------------------------------

A_700___funktion:
'
'-------------------------------------------------------------------------------
'70. === F U N K T I O N =======================================================
'-------------------------------------------------------------------------------

A_800___datenbereich:
'
'-------------------------------------------------------------------------------
'80. === D A T E N B E R E I C H ===============================================
'-------------------------------------------------------------------------------
'Anzeige Wochentag
'29.02.2022 - Feld mit fhrenden Leerstring, weil durch die LED-Anzeige Werte
'von 1-7 ausgewertet werden mssen.
Wochentag:
   Data " " , "Mo" , "Di" , "Mi" , "Do" , "Fr" , "Sa" , "So"
'
'Morsecode
'~~~~~~~~~
' Zahlen 0-9
Mc_zah:
   Data "-----" , ".----" , "..---" , "...--" , "....-" , "....." , "-...." , _
        "--..." , "---.." , "----."
' Buchstaben A-Z
Mc_buc:
   Data ".-" , "-..." , "-.-." , "-.." , "." , "..-." , "--." , "...." , _
        ".." , ".---" , "-.-" , ".-.." , "--" , ".-" , "---" , ".--." , _
        "--.-" , ".-." , "..." , "-" , "..-" , "...-" , ".--" , "-..-" , _
        "-.--" , "--.."
' Slave Adressen
Sla_adr:
   Data &H22 , &H24 , &H26 , &H28 , &H2A , &H2C , &H2E , &H30

'           &H22   &H24   &H26   &H28   &H2A   &H2C   &H2E   &H30
'             00  :  00  :  00     00  .  00  .  00     00    (LED)
'             hh  :  mm  :  ss     TT  .  MM  .  JJ     JJ     WT
' Zeit        ----------------
' Datum                            -----------------------
' Wochentag                                                    --

'Modus
'~~~~~
'Neben der vereinfachten Anzeige des aktuellen Modus erfolgt in der LCD-Anzeige
'eine erweiterte Anzeige.
Modus:
   Data "                " , _
        "Programmauswahl " , _
        "LCD Kontrast    " , _
        "Helligk. Anzeige" , _
        "Helligk. LED    " , _
        "Slaveanzahl     " , _
        "Sensorsteuerung " , _
        "Format Datum    " , _
        "Zeiteinstellung "

'Ende Datenbereich

'Variablen der Zeitangabe
'_sec, _min, _hour, _day, _month, _year

'###############################################################################

'Ende
